<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface RelusergrouppropertiesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Relusergroupproperties 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param relusergrouppropertie primary key
 	 */
	public function delete($relusergrouppropertiesid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Relusergroupproperties relusergrouppropertie
 	 */
	public function insert($relusergrouppropertie);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Relusergroupproperties relusergrouppropertie
 	 */
	public function update($relusergrouppropertie);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUsergroupid($value);

	public function queryByPropertyid($value);

	public function queryByPropertyvalue($value);


	public function deleteByUsergroupid($value);

	public function deleteByPropertyid($value);

	public function deleteByPropertyvalue($value);


}
?>